#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BusinessObjectException : BaseTest 
	{
		private string exceptionText = "BusinessObjectException";
		private string innerText = "InnerException";
		private string genericErrorText = "Exception of type 'gov.va.med.vbecs.BOL.BusinessObjectException' was thrown.";

		
		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
		}


		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BusinessObjectException tmpBOE = new BOL.BusinessObjectException();

			Assert.IsNotNull(tmpBOE);
		}

				
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}


		[Test]
		public void Ctor_String_Pass()
		{
			BOL.BusinessObjectException tmpBOE = new BOL.BusinessObjectException(exceptionText);

			Assert.IsTrue(tmpBOE.Message == exceptionText);
		}

		[Test]
		public void Ctor_String_Fail()
		{
			BOL.BusinessObjectException tmpBOE = new BOL.BusinessObjectException(null);

			Assert.IsTrue(tmpBOE.Message == genericErrorText);
		}

		[Test]
		public void Ctor_String_Exception_Pass()
		{
			BOL.BusinessObjectException tmpBOE =  new BOL.BusinessObjectException(exceptionText, new Exception(innerText));

			Assert.IsTrue(exceptionText == tmpBOE.Message);
			Assert.IsTrue(innerText == tmpBOE.InnerException.Message);
		}

		[Test]
		public void Ctor_String_Exception_Fail()
		{

			BOL.BusinessObjectException tmpBOE =  new BOL.BusinessObjectException(null, null);

			Assert.IsTrue(genericErrorText == tmpBOE.Message);
			Assert.IsNull(tmpBOE.InnerException);
		}

		[Test]
		public void GetObjectData_Pass()
		{
			BusinessObjectException _originalXcp = new BusinessObjectException( "Test", null );
			BinaryFormatter _formatter = new BinaryFormatter();
			MemoryStream _stream = new MemoryStream();

			_formatter.Serialize( _stream, _originalXcp );

			_stream.Seek(0, SeekOrigin.Begin );

			BusinessObjectException _reincarnatedXcp = (BusinessObjectException)_formatter.Deserialize( _stream );
			
			Assert.IsNotNull( _reincarnatedXcp );
			Assert.AreEqual( _originalXcp.Message, _reincarnatedXcp.Message );
			Assert.AreEqual( _originalXcp.OSVersion, _reincarnatedXcp.OSVersion );
			Assert.AreEqual( _originalXcp.MachineName, _reincarnatedXcp.MachineName );
			Assert.AreEqual( _originalXcp.StackTrace, _reincarnatedXcp.StackTrace );
			Assert.AreEqual( _originalXcp.UserName, _reincarnatedXcp.UserName );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetObjectData_Fail()
		{
		}


		[Test]
		public void OSVersion_Pass()
		{
			BOL.BusinessObjectException tmpBOE = new BOL.BusinessObjectException(exceptionText);
			string tstValue = tmpBOE.OSVersion;

			Assert.IsTrue(tmpBOE.OSVersion == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OSVersion_Fail()
		{
		}


		[Test]
		public void UserName_Pass()
		{
			BOL.BusinessObjectException tmpBOE = new BOL.BusinessObjectException(exceptionText);
			string tstValue = tmpBOE.UserName;

			Assert.IsTrue(tmpBOE.UserName == tstValue);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UserName_Fail()
		{
		}

	}

}
#endif


